/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.monitor;

import filenet.pa.admin.IPAAdministration;
import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.monitor.PAMonitorPropertyPanel;
import filenet.vw.base.VWDebug;
import java.rmi.RemoteException;

public class PAMonitorThread {
    private PANode m_paNode = null;
    private PAMonitorPropertyPanel m_monitorPanel = null;
    private boolean m_bRunning = false;

    public PAMonitorThread(PANode paNode, PAMonitorPropertyPanel monitorPropPanel) {
        this.m_paNode = paNode;
        this.m_monitorPanel = monitorPropPanel;
    }

    public synchronized void start() {
        final PAMonitorThread objInstance = this;
        if (!this.m_bRunning) {
            this.m_bRunning = true;
            Runnable monitorRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (PAMonitorThread.this.m_bRunning) {
                        try {
                            IPAAdministration paAdmin = PAMonitorThread.this.m_paNode.getPAAdministration();
                            if (paAdmin != null) {
                                try {
                                    PAMonitorThread.this.updateStatistics(paAdmin.getStatistics());
                                }
                                catch (RemoteException ex) {
                                    PAMonitorThread.this.clearStatistics();
                                }
                            }
                            Object object = objInstance;
                            synchronized (object) {
                                objInstance.wait(1000L);
                            }
                        }
                        catch (Exception e) {
                            VWDebug.logException(e, "Exception while updating pa statistics.");
                            PAMonitorThread.this.m_bRunning = false;
                        }
                    }
                }
            };
            Thread monitorThread = new Thread(monitorRunnable);
            monitorThread.setName(PAMonitorThread.class.getName());
            monitorThread.start();
        }
    }

    public synchronized void stop() {
        this.m_bRunning = false;
        this.notifyAll();
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    private void updateStatistics(PAStatisticsSnapShot stats) {
        if (!this.m_bRunning) {
            return;
        }
        this.m_paNode.updateStatistics(stats);
        this.m_monitorPanel.updateStatistics(stats);
    }

    private void clearStatistics() {
        this.m_monitorPanel.clearStatistics();
        this.m_paNode.updateStatistics(null);
    }
}

